
// STM32F103 hardware modules

#define TIMER1_BASE 0x40012C00
#define DDS_TIMER_CR1   (*((volatile uint32 *)(TIMER1_BASE+0x00)))
#define DDS_TIMER_CR2   (*((volatile uint32 *)(TIMER1_BASE+0x04)))
#define DDS_TIMER_SMCR  (*((volatile uint32 *)(TIMER1_BASE+0x08)))
#define DDS_TIMER_DIER  (*((volatile uint32 *)(TIMER1_BASE+0x0C)))
#define DDS_TIMER_SR    (*((volatile uint32 *)(TIMER1_BASE+0x10)))
#define DDS_TIMER_EGR   (*((volatile uint32 *)(TIMER1_BASE+0x14)))
#define DDS_TIMER_CCMR1 (*((volatile uint32 *)(TIMER1_BASE+0x18)))
#define DDS_TIMER_CCMR2 (*((volatile uint32 *)(TIMER1_BASE+0x1C)))
#define DDS_TIMER_CCER  (*((volatile uint32 *)(TIMER1_BASE+0x20)))
#define DDS_TIMER_CNT   (*((volatile uint32 *)(TIMER1_BASE+0x24)))
#define DDS_TIMER_PSC   (*((volatile uint32 *)(TIMER1_BASE+0x28)))
#define DDS_TIMER_ARR   (*((volatile uint32 *)(TIMER1_BASE+0x2C)))
#define DDS_TIMER_CCR1  (*((volatile uint32 *)(TIMER1_BASE+0x34)))
#define DDS_TIMER_CCR2  (*((volatile uint32 *)(TIMER1_BASE+0x38)))
#define DDS_TIMER_CCR3  (*((volatile uint32 *)(TIMER1_BASE+0x3C)))
#define DDS_TIMER_CCR4  (*((volatile uint32 *)(TIMER1_BASE+0x40)))
#define DDS_TIMER_DCR   (*((volatile uint32 *)(TIMER1_BASE+0x48)))
#define DDS_TIMER_DMAR  (*((volatile uint32 *)(TIMER1_BASE+0x4C)))

#define GPIOA_BASE 0x40010800
#define GPIOA_CRL  (*((volatile uint32 *)(GPIOA_BASE+0x00)))
#define GPIOA_CRH  (*((volatile uint32 *)(GPIOA_BASE+0x04)))
#define CRH_P8_CNFMODE_FLOAT     (0x4 << 0) // 01 00: input mode, floating
#define CRH_P8_MODE_50MHZ        (0x3 << 0) // 11: Output mode, max speed 50 MHz.
#define CRH_P8_MODE_2MHZ         (0x2 << 0) // 11: Output mode, max speed 2 MHz.
#define CRH_P8_CNF_ALT_PUSHPULL  (0x2 << 2) // 10: Alternate function output Push-pull
#define CRH_P9_MODE_50MHZ        (0x3 << 4) // 11: Output mode, max speed 50 MHz.
#define CRH_P9_CNF_ALT_PUSHPULL  (0x2 << 6) // 10: Alternate function output Push-pull
#define CRH_P10_CNFMODE_FLOAT    (0x4 << 8) // 01 00: input mode, floating
#define CRH_P10_MODE_50MHZ       (0x3 << 8) // 11: Output mode, max speed 50 MHz.
#define CRH_P10_CNF_ALT_PUSHPULL (0x2 <<10) // 10: Alternate function output Push-pull
#define GPIOA_ODR (*((volatile uint32 *)(GPIOA_BASE+0x0C)))

#define RCC_BASE 0x40021000 
#define RCC_AHBENR (*((volatile uint32 *)(RCC_BASE+0x14)))

#define DMA1_BASE 0x40020000
#define DMA_ISR    (*((volatile uint32 *)(DMA1_BASE+0x00)))
#define DMA_IFCR   (*((volatile uint32 *)(DMA1_BASE+0x04)))
#define DMA_CCR3   (*((volatile uint32 *)(DMA1_BASE+0x30)))
#define DMA_CNDTR3 (*((volatile uint32 *)(DMA1_BASE+0x34)))
#define DMA_CPAR3  (*((volatile uint32 *)(DMA1_BASE+0x38)))
#define DMA_CMAR3  (*((volatile uint32 *)(DMA1_BASE+0x3C)))

#define DMA_CCR_MEM2MEM                 (1U  << 14)
#define DMA_CCR_PL                      (0x3 << 12)
#define DMA_CCR_PL_LOW                  (0x0 << 12)
#define DMA_CCR_PL_MEDIUM               (0x1 << 12)
#define DMA_CCR_PL_HIGH                 (0x2 << 12)
#define DMA_CCR_PL_VERY_HIGH            (0x3 << 12)
#define DMA_CCR_MSIZE                   (0x3 << 10)
#define DMA_CCR_MSIZE_8BITS             (0x0 << 10)
#define DMA_CCR_MSIZE_16BITS            (0x1 << 10)
#define DMA_CCR_MSIZE_32BITS            (0x2 << 10)
#define DMA_CCR_PSIZE                   (0x3 << 8)
#define DMA_CCR_PSIZE_8BITS             (0x0 << 8)
#define DMA_CCR_PSIZE_16BITS            (0x1 << 8)
#define DMA_CCR_PSIZE_32BITS            (0x2 << 8)
#define DMA_CCR_MINC                    (1U  << 7)
#define DMA_CCR_PINC                    (1U  << 6)
#define DMA_CCR_CIRC                    (1U  << 5)
#define DMA_CCR_DIR_FROM_PER            (0U  << 4)
#define DMA_CCR_DIR_FROM_MEM            (1U  << 4)
#define DMA_CCR_TEIE                    (1U  << 3)
#define DMA_CCR_HTIE                    (1U  << 2)
#define DMA_CCR_TCIE                    (1U  << 1)
#define DMA_CCR_EN                      (1U  << 0)

#define DMA_ISR_TCIF3   (1U <<  9)
#define DMA_ISR_HTIF3   (1U << 10)

#define DMA_IFCR_CTCIF3 (1U <<  9)
#define DMA_IFCR_CHTIF3 (1U << 10)
#define DMA_IFCR_CGIF3  (1U <<  8)

