#pragma once
#ifndef Lib_app
#define Lib_app

#ifdef DEBUG_CONSOLE
#define DEBUG_MESSAGE(msg) Serial.println(msg)
#define DEBUG_VALUE(msg,v) {Serial.print(msg); Serial.println(v);}
#else
#define DEBUG_MESSAGE(msg) 
#define DEBUG_VALUE(msg,v) 
#endif

// program name
#define APP_NAME "Teensy Drone"
#define APP_DATE "2023.05.05"

// portrait mode display, no touch panel
#define DISP_H 320
#define DISP_W 240
#define BL_PIN 2              // display backlight PWM
#define MIN_BRIGHTNESS  64
#define MAX_BRIGHTNESS 255

// status LED, normally on solid
#define STATUS_LED_PIN 15
#define BLINK_ERR_EEPROM    1 // 1 blink: no eeprom
#define BLINK_ERR_VELOCIBUS 2 // 2 blink: no knobs

// common data structures
#include "EE_DB.h"

#endif
