//------------------------------------------------------
// Shared between UI (RP2040) and Synth (Teensy)

#pragma once
#ifndef Lib_common
#define Lib_common

// MIDI program change sets mode
#define NUM_MODES 4
#define MODE_BENJOLIN 0
#define MODE_BLIPPO1  1
#define MODE_BLIPPO2  2
#define MODE_BLIPPO3  3

// MIDI CC's
#define ccVOLUME             7
#define ccSTEREO            82
#define ccOSC1_FREQ         26
#define ccOSC1_SH_MOD       20
#define ccOSC1_RUNGLER_MOD  23
#define ccOSC1_CROSS_MOD    21
#define ccOSC2_FREQ         27
#define ccOSC2_RUNGLER1_MOD 24
#define ccOSC2_RUNGLER2_MOD 25
#define ccOSC2_CROSS_MOD    22

#define ccCOMPARE_MIX       16
#define ccOSC1_MIX          17
#define ccOSC2_MIX          18
#define ccFILTER_FREQ       74
#define ccFILTER_Q          71
#define ccFMOD_RUNGLER1     85
#define ccFMOD_OSC2         86
#define ccFMOD_DC           87

#define ccSH_MIX            79
#define ccSH_RUNGLER1       89
#define ccSH_RUNGLER2       90
#define ccLADDER1_FREQ      76
#define ccLADDER2_FREQ      77
#define ccLADDER_Q          75

// property calculations

float fscale( float originalMin, float originalMax, float newBegin, float newEnd, float inputValue, float curve);

#define SCALE(v)            (v/127.0)
#define OSC_FREQ(v)         fscale( 0, 127.0, 0.1, 12000.0, v, -9.3)
#define FILTER_FREQ(v)      fscale( 0, 127.0,  20, 12000.0, v, -9.3)
#define FILTER_RESONANCE(v) (1.8 * SCALE(v))
#define LADDER_FREQ(v)      fscale( 0, 127.0,  20, 12000.0, v, -9.3)
#define LADDER_RESONANCE(v) (1.8 * SCALE(v))

#endif
