#pragma once
#ifndef Lib_Help
#define Lib_Help

struct HELP_T
{
  String page_title;
  struct { String title; String body; } knob[6];
};

#define INACTIVE_KNOB_HELP "Knobs with a red LED are inactive.\n> Turn any knob to see help for the other knobs.\n> Press any knob to exit Help."
#define MULTIBUTTON_HELP "This is a multiple setting field.\n>Press the knob to select a setting.\n>Turn the knob to change the selected setting."

#define ABOUT_DESC    "The About page provides device information and basic settings (channel and brightness).\n\n"
#define HOME_DESC     "The Home page.\n\n"
#define OSC1_DESC     "The Oscillator 1 page shows all the settings for Oscillator 1.\n\n"
#define OSC2_DESC     "The Oscillator 2 page shows all the settings for Oscillator 2.\n\n"
#define BJMIX_DESC    "The Benjolin Mix page shows all of the Benjolin audio mix settings.\n\n"
#define BJFILTER_DESC "The Benjolin Filter page shows all of the Benjolin filter settings.\n\n"
#define BLIPPO_DESC   "The Blippo page shows all of the Blippo settings.\n\n"
#define JAM_DESC      "The Jam page has all of the settings for the current mode (Benjolin or Blippo) on one page using layered settings; press the knob to select a setting.\n\n"

const HELP_T help_database[] =
{
  { "Home", { // 0
    { "Help",   HOME_DESC INACTIVE_KNOB_HELP }, 
    { "Help",   HOME_DESC INACTIVE_KNOB_HELP }, 
    { "Mode",   HOME_DESC "'Mode' selects Benjolin or Blippo mode. Each mode has it's own settings." },
    { "Help",   HOME_DESC INACTIVE_KNOB_HELP }, 
    { "Output", HOME_DESC "'Output' can be Mono or Stereo. The stereo effect is simulated." },
    { "Volume", HOME_DESC "'Volume' is the master output volume. This applies to all modes." }
  }},

  { "Oscillator 1", { // 1
    { "Frequency",   OSC1_DESC "'Frequency' is the oscillator base frequency. The frequency is on a log scale, so it can be used as a LFO or audio tones." },
    { "Help",        OSC1_DESC INACTIVE_KNOB_HELP }, 
    { "Help",        OSC1_DESC INACTIVE_KNOB_HELP }, 
    { "S/H Mod",     OSC1_DESC "'S/H Mod' is the amount of frequency modulation from the Blippo sample-and-hold." },
    { "Rungler Mod", OSC1_DESC "'Rungler Mod' is the amount of frequency modulation from the Rungler." },
    { "Cross Mod",   OSC1_DESC "'Cross Mod' is the amount of frequency modulation from Oscillator 2." }
  }},

  { "Oscillator 2", { // 2
    { "Frequency",   OSC2_DESC "'Frequency' is the oscillator base frequency. The frequency is on a log scale, so it can be used as a LFO or audio tones." },
    { "Help",        OSC2_DESC INACTIVE_KNOB_HELP }, 
    { "Help",        OSC2_DESC INACTIVE_KNOB_HELP }, 
    { "Rungler 1",   OSC2_DESC "'Rungler 1' is the amount of frequency modulation from the primary Rungler." },
    { "Rungler 2",   OSC2_DESC "'Rungler 2' is the amount of frequency modulation from the secondary Rungler." },
    { "Cross Mod",   OSC2_DESC "'Cross Mod' is the amount of frequency modulation from Oscillator 1." }
  }},

  { "Benjolin Mix", { //       3
    { "Oscillator 1", BJMIX_DESC "'Oscillator 1' is the amount of Oscillator 1 to include in the audio mix." },
    { "Oscillator 2", BJMIX_DESC "'Oscillator 2' is the amount of Oscillator 2 to include in the audio mix." },
    { "Compare",      BJMIX_DESC "'Compare' is the amount of comparator output to include in the audio mix. The comparator input is Oscillator 1 vs. Oscillator 2." },
    { "Help",         BJMIX_DESC INACTIVE_KNOB_HELP }, 
    { "Help",         BJMIX_DESC INACTIVE_KNOB_HELP }, 
    { "Help",         BJMIX_DESC INACTIVE_KNOB_HELP } 
  }},
  
  { "Benjolin Filter", { //    4
    { "Frequency",    BJFILTER_DESC "'Frequency' is the filter corner frequency. The frequency is on a log scale." },
    { "Resonance",    BJFILTER_DESC "'Resonance' is the filter's response level near the corner frequency." },
    { "Help",         BJMIX_DESC INACTIVE_KNOB_HELP }, 
    { "Rungler",      BJFILTER_DESC "'Rungler' is the amount of rungler output to use for filter frequency modulation." },
    { "Osc 2",        BJFILTER_DESC "'Osc 2' is the amount of Oscillator 2 to use for filter frequency modulation." },
    { "Fixed",        BJFILTER_DESC "'Fixed' applies a constant level to the filter frequency modulation." }
  }},

  { "Blippo", { //     5
    { "S/H Mix",      BLIPPO_DESC "'S/H Mix' is the amount of Sample-and-hold output to include in the audio mix." },
    { "Rungler 1",    BLIPPO_DESC "'Rungler 1' is the amount of the primary Rungler output to include in the audio mix." },
    { "Rungler 2",    BLIPPO_DESC "'Rungler 2' is the amount of the secondary Rungler output to include in the audio mix." },
    { "Filter 1",     BLIPPO_DESC "'Filter 1' is the corner frequency for one of the Ladder filters." },
    { "Filter 2",     BLIPPO_DESC "'Filter 2' is the corner frequency for one of the Ladder filters." },
    { "Filter Res",   BLIPPO_DESC "'Filter Res' is the ladder filter resonance." }
  }},

  { "Jam", { //     6
    { "Osc 1",        BLIPPO_DESC "'Osc 1' is the Oscillator 1 frequency." },
    { "Multibutton",  BLIPPO_DESC MULTIBUTTON_HELP },
    { "Multibutton",  BLIPPO_DESC MULTIBUTTON_HELP },
    { "Osc 2",        BLIPPO_DESC "'Osc 2' is the Oscillator 2 frequency." },
    { "Multibutton",  BLIPPO_DESC MULTIBUTTON_HELP },
    { "Multibutton",  BLIPPO_DESC MULTIBUTTON_HELP }
  }},

  { "About", { //     7
    { "Help",       ABOUT_DESC INACTIVE_KNOB_HELP }, 
    { "Help",       ABOUT_DESC INACTIVE_KNOB_HELP }, 
    { "Channel",    ABOUT_DESC "'Channel' is the MIDI channel for control settings. This can be a particular channel, all channels, or none.\nMIDI control is not required; manual control is always available.\nNote On and Note Off messages are always recognized, from any channel." },
    { "Help",       ABOUT_DESC INACTIVE_KNOB_HELP }, 
    { "Help",       ABOUT_DESC INACTIVE_KNOB_HELP }, 
    { "Brightness", ABOUT_DESC "'Brightness' is the display brightness. The display brightness can't be turned fully off." }
  }}
};

#endif
