// comparator

// block a = signal 1
// block b = signal 2

#include <Arduino.h>
#include "effect_comparator.h"

#define VMAX 30000

void AudioEffectComparator::update(void)
{
  audio_block_t *blocka, *blockb;
  uint32_t *pa, *pb, *end;

  blocka = receiveWritable(0);
  blockb = receiveReadOnly(1);

  if (!blocka) { if (blockb) release(blockb); return; }
  if (!blockb) { release(blocka); return; }

  for (pa = (uint32_t *)(blocka->data),
       pb = (uint32_t *)(blockb->data),
       end= (uint32_t *)(blocka->data) + AUDIO_BLOCK_SAMPLES;
       pa < end; pa+=8, pb+=8)
  {
    // 8 at a time
    *(pa+0) = (*(pa+0) > *(pb+0)) ? VMAX : -VMAX;
    *(pa+1) = (*(pa+1) > *(pb+1)) ? VMAX : -VMAX;
    *(pa+2) = (*(pa+2) > *(pb+2)) ? VMAX : -VMAX;
    *(pa+3) = (*(pa+3) > *(pb+3)) ? VMAX : -VMAX;
    *(pa+4) = (*(pa+4) > *(pb+4)) ? VMAX : -VMAX;
    *(pa+5) = (*(pa+5) > *(pb+5)) ? VMAX : -VMAX;
    *(pa+6) = (*(pa+6) > *(pb+6)) ? VMAX : -VMAX;
    *(pa+7) = (*(pa+7) > *(pb+7)) ? VMAX : -VMAX;
  }    
 
  transmit(blocka);
  release(blocka);
  release(blockb);
}
